# ✅ Checklist de Deploy - repertorio.rgestor.com.br

## 🎯 Status Atual: PRONTO PARA DEPLOY

### ✅ Preparação Concluída

- [x] **Build de produção gerado** com sucesso
- [x] **Variáveis de ambiente configuradas** para `repertorio.rgestor.com.br`
- [x] **Banco de dados Neon** já funcionando
- [x] **Arquivo server.js** criado para cPanel
- [x] **Configurações de segurança** aplicadas

## 📋 Próximos Passos no cPanel

### 1. Upload dos Arquivos ⬆️

**Faça upload destes arquivos/pastas para `public_html`:**

```
📁 Arquivos OBRIGATÓRIOS:
├── .next/                    ← Pasta do build (IMPORTANTE!)
├── app/                      ← Código da aplicação
├── components/               ← Componentes React
├── lib/                      ← Bibliotecas
├── public/                   ← Arquivos estáticos
├── styles/                   ← Estilos CSS
├── .env.production          ← Variáveis de ambiente
├── next.config.mjs          ← Configuração Next.js
├── package.json             ← Dependências
├── package-lock.json        ← Lock das dependências
├── server.js                ← Servidor para cPanel
└── tsconfig.json            ← Config TypeScript
```

**❌ NÃO envie:**
- `node_modules/` (será instalado no servidor)
- `.env.local` (apenas desenvolvimento)
- `.git/` (controle de versão)

### 2. Configurar Node.js App 🔧

1. **cPanel → Node.js App → Create Application**
2. **Configurações:**
   ```
   Application Root: public_html
   Application URL: /
   Startup File: server.js
   Node.js Version: 18.x ou superior
   ```

### 3. Variáveis de Ambiente 🔐

**Adicione no cPanel (Node.js App → Environment Variables):**

```
NODE_ENV=production
DATABASE_URL=postgresql://neondb_owner:npg_UOAik7P4RMDy@ep-fragrant-cherry-acdsxy1y-pooler.sa-east-1.aws.neon.tech/neondb?sslmode=require
MASTER_USER_EMAIL=creativegrowgarca@gmail.com
MASTER_USER_NAME=Creative Grow
MASTER_USER_PASSWORD=@Sucesso2021
NEXTAUTH_SECRET=repertorio-production-secret-key-2024-super-secure-change-this
NEXT_PUBLIC_APP_URL=https://repertorio.rgestor.com.br
NEXTAUTH_URL=https://repertorio.rgestor.com.br
ALLOWED_ORIGINS=https://repertorio.rgestor.com.br
```

### 4. Instalar Dependências 📦

**No cPanel (Node.js App):**
- Clique em "Run NPM Install"
- Aguarde a instalação completar

### 5. Iniciar Aplicação 🚀

- Clique em "Start App"
- Aguarde alguns segundos
- Acesse: `https://repertorio.rgestor.com.br`

## 🧪 Teste Final

### Verificações Essenciais:

- [ ] Site carrega sem erros
- [ ] Login funciona (use: creativegrowgarca@gmail.com)
- [ ] Dashboard do usuário abre
- [ ] Consegue adicionar músicas
- [ ] Player de música funciona

## 🆘 Se Algo Der Errado

### Logs de Erro:
- **cPanel → Node.js App → sua aplicação → Logs**

### Problemas Comuns:

**"Module not found"**
```bash
# No terminal SSH ou cPanel
npm install --production
```

**"Database connection failed"**
- Verifique se as variáveis de ambiente estão corretas
- Teste a conexão Neon separadamente

**"Port already in use"**
- Reinicie a aplicação no cPanel

## 📞 Informações Importantes

- **URL da aplicação:** https://repertorio.rgestor.com.br
- **Banco de dados:** Neon PostgreSQL (já configurado)
- **Login master:** creativegrowgarca@gmail.com
- **Senha master:** @Sucesso2021

---

## 🎉 Após o Deploy

Sua aplicação de repertório musical estará disponível em:
**https://repertorio.rgestor.com.br**

✅ **Tudo está pronto para o deploy!** 🎵