# Solucionando Erro 503 - Service Unavailable

## O que você fez errado?

Analisando as imagens do cPanel, identifiquei alguns problemas na configuração:

### 1. **Problema Principal: Configuração do server.js**
O `server.js` original estava configurado para `localhost`, mas no cPanel você precisa que ele funcione sem especificar hostname.

**✅ CORRIGIDO:** Atualizei o `server.js` para remover as referências ao `localhost`.

### 2. **Possíveis Problemas Restantes:**

#### A. **Porta Incorreta**
- O cPanel pode estar esperando uma porta específica
- Verifique se a porta configurada no cPanel coincide com a do aplicativo

#### B. **Dependências Não Instaladas**
- Clique em "Executar a instalação do NPM" no cPanel
- Aguarde a instalação completa das dependências

#### C. **Variáveis de Ambiente**
- Verifique se todas as variáveis estão corretas (principalmente DATABASE_URL)
- Certifique-se que não há espaços extras nos valores

## Passos para Resolver:

### 1. **Fazer Upload do server.js Corrigido**
```bash
# Faça upload do server.js atualizado para o cPanel
```

### 2. **Instalar Dependências**
No cPanel:
- Clique em "Executar a instalação do NPM"
- Aguarde até aparecer "Concluído"

### 3. **Verificar Variáveis de Ambiente**
Confirme estas variáveis no cPanel:
```
DATABASE_URL=postgresql://neondb_owner:npg_UOAk7P4RMDy@ep-fragrant-cherry-a04avy1y-pooler.us-east-1.aws.neon.tech/neondb?sslmode=require
MASTER_USER_EMAIL=creativegrowgarca@gmail.com
MASTER_USER_NAME=Creative Grow
MASTER_USER_PASSWORD=@Sucesso2021
NEXTAUTH_SECRET=repertorio-production-secret-key-2024-super-secure-change-this
NEXTAUTH_URL=https://repertorio.rgestor.com.br
NEXT_PUBLIC_APP_URL=https://repertorio.rgestor.com.br
NODE_ENV=production
ALLOWED_ORIGINS=https://repertorio.rgestor.com.br
```

### 4. **Reiniciar a Aplicação**
- Clique em "REINICIAR" no cPanel
- Aguarde alguns minutos para o servidor inicializar

### 5. **Verificar Logs**
Se ainda não funcionar:
- Verifique os logs de erro no cPanel
- Procure por mensagens de erro específicas

## Arquivos Atualizados:
- ✅ `server.js` - Corrigido para cPanel
- ✅ `.env.production` - Configurado corretamente
- ✅ Build de produção - Gerado com sucesso

## Próximos Passos:
1. Faça upload do `server.js` corrigido
2. Execute a instalação do NPM
3. Reinicie a aplicação
4. Teste o site

Se o erro persistir, verifique os logs do cPanel para identificar o problema específico.