import { type NextRequest, NextResponse } from "next/server"
import { neon } from "@neondatabase/serverless"
import bcrypt from "bcryptjs"

const sql = neon(process.env.DATABASE_URL!)

export async function POST(request: NextRequest) {
  try {
    const { name, email, password } = await request.json()

    // Check if user already exists
    const existingUsers = await sql`
      SELECT id FROM users WHERE email = ${email}
    `

    if (existingUsers.length > 0) {
      return NextResponse.json(
        {
          success: false,
          message: "Usuário já cadastrado com este email",
        },
        { status: 400 },
      )
    }

    // Hash the password before saving
    const passwordHash = await bcrypt.hash(password, 10)

    // Insert new user
    const result = await sql`
      INSERT INTO users (name, email, password_hash, is_active, is_master)
      VALUES (${name}, ${email}, ${passwordHash}, false, false)
      RETURNING id, name, email, is_active, is_master, created_at
    `

    return NextResponse.json({
      success: true,
      message: "Cadastro realizado! Aguarde aprovação do administrador.",
      user: result[0],
    })
  } catch (error) {
    console.error("Register error:", error)
    return NextResponse.json(
      {
        success: false,
        message: "Erro interno do servidor",
      },
      { status: 500 },
    )
  }
}
