import type React from "react"
import type { Metadata } from "next"
import { GeistSans } from "geist/font/sans"
import { GeistMono } from "geist/font/mono"
import { Analytics } from "@vercel/analytics/next"
import "./globals.css"

import { Suspense } from "react"

export const metadata: Metadata = {
  title: "Gestor de Repertório",
  description: "Sistema de gerenciamento de repertório para shows",
  generator: "v0.app",
}

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode
}>) {
  return (
    <html lang="pt-BR" className={`${GeistSans.variable} ${GeistMono.variable}`}>
      <body className={`font-sans antialiased`}>
        <Suspense fallback="Loading...">{children}</Suspense>
        <Analytics />
      </body>
    </html>
  )
}
