-- Criar tabela de grupos de repertório
CREATE TABLE IF NOT EXISTS repertoire_groups (
    id SERIAL PRIMARY KEY,
    user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
    name VARCHAR(255) NOT NULL,
    description TEXT,
    color VARCHAR(7) DEFAULT '#3B82F6', -- Cor em hexadecimal
    position INTEGER DEFAULT 0, -- Para ordenação drag-and-drop
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Criar índices
CREATE INDEX IF NOT EXISTS idx_repertoire_groups_user_id ON repertoire_groups(user_id);
CREATE INDEX IF NOT EXISTS idx_repertoire_groups_position ON repertoire_groups(user_id, position);
