-- Criar tabela de músicas
CREATE TABLE IF NOT EXISTS songs (
    id SERIAL PRIMARY KEY,
    repertoire_group_id INTEGER NOT NULL REFERENCES repertoire_groups(id) ON DELETE CASCADE,
    title VARCHAR(255) NOT NULL,
    artist VARCHAR(255) NOT NULL,
    youtube_url TEXT,
    youtube_video_id VARCHAR(20), -- ID extraído da URL do YouTube
    duration INTEGER, -- Duração em segundos
    position INTEGER DEFAULT 0, -- Para ordenação drag-and-drop dentro do grupo
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Criar índices
CREATE INDEX IF NOT EXISTS idx_songs_repertoire_group_id ON songs(repertoire_group_id);
CREATE INDEX IF NOT EXISTS idx_songs_position ON songs(repertoire_group_id, position);
CREATE INDEX IF NOT EXISTS idx_songs_youtube_video_id ON songs(youtube_video_id);
