const { createServer } = require('http')
const { parse } = require('url')
const next = require('next')

const dev = process.env.NODE_ENV !== 'production'
const port = process.env.PORT || 3000

// Inicializar aplicação Next.js
const app = next({ dev })
const handle = app.getRequestHandler()

app.prepare().then(() => {
  createServer(async (req, res) => {
    try {
      // Parse da URL
      const parsedUrl = parse(req.url, true)
      
      // Lidar com a requisição
      await handle(req, res, parsedUrl)
    } catch (err) {
      console.error('Erro ao processar requisição:', req.url, err)
      res.statusCode = 500
      res.end('Erro interno do servidor')
    }
  })
  .listen(port, (err) => {
    if (err) throw err
    console.log(`🚀 Servidor rodando na porta ${port}`)
    console.log(`📱 Ambiente: ${process.env.NODE_ENV || 'development'}`)
  })
})

// Tratamento de erros não capturados
process.on('unhandledRejection', (err) => {
  console.error('Erro não tratado:', err)
})

process.on('uncaughtException', (err) => {
  console.error('Exceção não capturada:', err)
  process.exit(1)
})